//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.2
import wesual.Controls 1.0

Item {
    id : control

    property alias  text        : content.text
    property alias  fontSize    : content.font.pixelSize
    property alias  color       : content.color
    property bool   checked     : false
    property bool   canToggle   : false
    property bool   bottomLine  : true
    property int    margins     : 2

    implicitWidth : content.contentWidth + 2*margins

    Text {
        id : content
        font {
            family : UI.fontFamily(UI.PrimaryFont)
            weight : UI.fontWeight(UI.PrimaryFont)
            pixelSize : 18
        }
        maximumLineCount : 1
        elide : Qt.ElideRight
        color : {
            if (control.checked) {
                return UI.color(UI.SecondaryBase);
            } else if (hoverArea.pressed) {
                return UI.color(UI.SecondaryPress);
            } else if (hoverArea.containsMouse) {
                return UI.color(UI.SecondaryHover);
            } else {
                return UI.color(UI.PrimaryTextColor);
            }
        }

        anchors {
            left : parent.left
            leftMargin : control.margins
            top : parent.top
        }
        height : 23

        Behavior on color { ColorAnimation { duration : 0 } }
    }


    Rectangle {
        id : bottomBar
        visible : bottomLine
        anchors.bottom : parent.bottom
        height : 1
        width : parent.width
        color : {
            if (control.checked) {
                return UI.color(UI.TabButtonBorder);
            } else if (hoverArea.pressed) {
                return UI.color(UI.SecondaryPress);
            } else if (hoverArea.containsMouse) {
                return UI.color(UI.SecondaryHover);
            }

            return UI.color(UI.TertiarySeparationLine);
        }

        Behavior on color { ColorAnimation { duration : 0 } }
    }


    MouseArea {
        id : hoverArea
        anchors.fill : control
        hoverEnabled : true
        onClicked : {
            if(control.canToggle){
                control.checked = !control.checked;
                return;
            }
            control.checked = true;
        }
        cursorShape : Qt.PointingHandCursor
    }
}
